/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/ 

/*
 *  UART CIR Test
 *
 */

#include "irReceiver.h"
#include "stdio.h"
#include "ioexpander.h"





/* ------------------------------------------------------------------------ *
 *  init_cir( )                                                             *
 * ------------------------------------------------------------------------ */
INT16 init_cir( )
{
	// Being Tested for using UART1 in UART mode
	
	UART_Handle uart = DM814x_UART1_BASE;
	UINT32 efr_val;
	
	/* Reset the UART from any previous state */
	/* Reset Sequence */
	UART_rset( uart, EFR, 0x10 );
	UART_rset( uart, IER_OFFSET, 0 );
	UART_rset( uart, MCR_OFFSET, 0 );
	UART_rset( uart, EFR, 0 );
	UART_rset( uart, LCR_OFFSET, 0 );
	
	UART_rset( uart, MDR1_OFFSET, 0x07 );
	
	efr_val = UART_rget(uart, EFR);
	UART_rset(uart, EFR, (efr_val | 0x10));	// Enable enhanced features, allow access to IER[4:7], FCR[4:5], MCR[5:7]
	UART_rset(uart, IER_OFFSET, 0x00);	// Disable All Interrupts
	UART_rset(uart, FCR_OFFSET, 0x57);
	UART_rset(uart, LCR_OFFSET, 0x02);
	UART_rset(uart, MCR_OFFSET, 0x00);	// No MODEM Configuration
	UART_rset(uart, EFR, efr_val);	// Disable enhanced features, allow access to IER[4:7], FCR[4:5], MCR[5:7]
	
	UART_rset(uart, MDR1_OFFSET, 0x07);	// Disable UART
	
	UART_rset(uart, DLL, 0x6B);	// Configure the Baud Rate for Transfer
	UART_rset(uart, DLH, 0x0A);
	
	UART_rset(uart, MDR1_OFFSET, 0x00);	// Select UART Mode
	
	return 0;
}

/* ------------------------------------------------------------------------ *
 *  read_cir_value( )                                                       *
 * ------------------------------------------------------------------------ */
INT8 read_cir_value( )
{
	INT8 i, num_key;
	INT32 uart_timeout = ( 0x00100000 );
	UINT8 read[3] = { 0, 0, 0 };
	

	UART_Handle uart = DM814x_UART1_BASE;

	for ( i = 0 ; i < 3 ; i++ )
	{
    	UART_rget( uart, RESUME_OFFSET );
		
		// For testing in UART mode
		while ((UART_rget( uart, LSR_OFFSET) & 0x01 ) == 0 )
		{
			if ( uart_timeout-- < 0 ) {
				printf("Timeout occured while receiving\n");
				return 1;
			}
		}
		
		read[i] = ( UINT8 )UART_rget( uart, RHR_OFFSET );
    }
	
	
	printf("Received Code Value: 0x%02X%02X%02X\n", read[0], read[1], read[2]);
	
	if (((read[0] == 0x25) || (read[0] == 0x29)) && (read[1] == 0x55)) {
		switch (read[2])
		{
			case 0x35:
				num_key = 1;
				break;
			case 0x4D:
				num_key = 2;
				break;
			case 0x2D:
				num_key = 3;
				break;
			case 0x53:
				num_key = 4;
				break;
			case 0x33:
				num_key = 5;
				break;
			case 0x4B:
				num_key = 6;
				break;
			case 0x2B:
				num_key = 7;
				break;
			case 0x6A:
				num_key = 8;
				break;
			case 0x5A:
				num_key = 9;
				break;
			case 0x55:
				num_key = 0;
				break;
			default:
				num_key = 11;
		}
		
		if ((num_key >= 0) && (num_key <= 9))
		{
			printf("Numeric Key %d is pressed.\n", num_key);
		}
	}
	
	return 0;
}

/* ------------------------------------------------------------------------ *
 *  uart_cir_test( )                                                        *
 * ------------------------------------------------------------------------ */
INT16 IR_Test( )
{
	UINT32 u32RetVal;
	
    u32RetVal = i2cIoExpInit(GPIO_EXP_I2C_BUS_NUM,GPIO_EXP_SLAVE_ADDR);
    
   
    
    if (u32RetVal != SUCCESS)
        {
        printf ("Unable to initialize the IO Expander on the base board.\r\n");
        return (u32RetVal);
        }
    
   
    u32RetVal = i2c0IoExpStatusBitSet(GPIO_EXP_I2C_BUS_NUM,GPIO_EXP_SLAVE_ADDR,14,0);
    if (u32RetVal != SUCCESS)
        {
        printf ("Unable to disable the transceiver on Base board.\r\n");
        return (u32RetVal);
        }
    init_cir( );
	
    printf( "\n" );
    printf( "**************************************** \n" );
    printf( "*** Press any key from the IR remote *** \n" );
    printf( "**************************************** \n" );

	return read_cir_value( );
}
